<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

function print_pre($data)
{ 
  echo "<pre>";print_r($data);echo "</pre>";       
}

function print_ex($data)
{ 
  echo "<pre>";print_r($data);echo "</pre>";exit();       
}

function csrf_field()
{ 
  $ci =& get_instance();
  $csrf = array(
    'name' => $ci->security->get_csrf_token_name(),
    'hash' => $ci->security->get_csrf_hash()
);      
  return '<input type="hidden" name="'.$csrf['name'].'" value="'.$csrf['hash'].'" />';       
}
function hashcode($data)
{
  return hash('sha512',$data);
}

function ci_encrypt($str){
  $year = date('Y');
  $str = rand(10,1000)."|".$str."|".$year;
  $str = rtrim( strtr( base64_encode( $str ), '+/', '-_'), '=');
  return $str;
} 
function ci_decrypt($str){
  $str = base64_decode( strtr( $str, '-_', '+/') . str_repeat('=', 3 - ( 3 + strlen( $str )) % 4 ));
  $str_arr = explode("|", $str);
  if(count($str_arr)==3) {
    if($str_arr['2']==date('Y')) {
      $str = $str_arr['1'];
  }
} else {
    $str = "";
}
return $str;
} 

function message()
{ 
  $ci =& get_instance();

  if($ci->session->flashdata('success_message')){ 
   return '<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 col-lg-offset-2 col-md-offset-2 ">
   <div class="alert alert-success alert-dismissable fade in radius-flat">
   <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
   <strong> '.$ci->session->flashdata('success_message').' </strong>
   </div>
   </div>';
} 
if($ci->session->flashdata('error_message')){ 
   return '<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 col-lg-offset-2 col-md-offset-2 ">
   <div class="alert alert-danger alert-dismissable fade in radius-flat">
   <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
   <strong>'.$ci->session->flashdata('error_message').' </strong>
   </div>
   </div>';
}       
}
function checkLink($url)
{    
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_HEADER, true);
  curl_setopt($ch, CURLOPT_NOBODY, true);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_TIMEOUT, 10);
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
  curl_exec($ch);
  return curl_getinfo($ch, CURLINFO_HTTP_CODE);      
}  
function checkLinkOld($url)
{    
  $headers = get_headers($url);
  return substr($headers[0], 9, 3);      
}
function strFlat($value)
{
  return strtolower(str_replace(" ", "_", $value)); 
}

function userIp()
{
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } else if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return  $ip;
}

function svg($file) {
    $svgUrl =  base_url().$file;
    echo file_get_contents($svgUrl);
}

function checkEmptyVal($val) {
    return ($val != ' ' && $val != null && $val != 'NA') ? $val : '';
}
function isEmptyVal($val) {
    return ($val == ' ' || $val == null || $val == 'NA') ? true : false;
}

function fileWithVersion($file) {
    return base_url().$file.'?v='.filemtime('./'.$file);
}
function resJson($data) {
    echo json_encode($data); exit;
}
function returnJson($data) {
    echo json_encode($data);
    exit;
}

function checkAjax() {
    $ci =& get_instance();
    if(!$ci->input->is_ajax_request()){ exit('No direct script access allowed'); }
}

// ------------------------------------------------------------
function strRepRegex($column, $value, $con) {
  $str = '';
  $conStr = ($con=='no') ? 'NOT REGEXP' : 'REGEXP';
  if (!empty($value)) {
    $replacedStr = str_replace("," , "|", $value);              
    $str = " AND $column $conStr '$replacedStr'";      
}
return $str;
}
function strRepEq($column, $value) {
  if (empty($value)) {
    return '';              
}
return " AND $column = '$value' ";
}
function strRepIn($column, $value) {
  $str = '';
  if (!empty($value)) {
    $replacedStr = str_replace("," , "','", $value);              
    $str = " AND $column IN ('$replacedStr')";      
}
return $str;
}
function strRepBetween($column, $value) {
  $str = '';
  if (!empty($value)) {
    $split = explode('-', $value);  
    if (count($split) > 1) {        
      $str = " AND $column BETWEEN $split[0] AND $split[1] ";     
  }
}
return $str;
}
// ------------------------------------------------------------

function hasValue($value='') {
    $value = trim($value);
    return (!empty($value) && $value != 'NA' && $value != 0) ? 1 : 0;
}    

function guardEmpty($value) {
    if (empty($value)) {
        exit;
    }
}

function flashData($name) {
  $ci =& get_instance();

  $flash = $ci->session->flashdata($name) ?? '';
  $ci->session->set_flashdata($name, '');
  return $flash;
}

function centToDollar($price) {
    return ($price ? $price / 100 : 0);
}

function multiArrayDiff($array1, $array2)
{
    $diffArray1 = array_udiff($array1, $array2, function($a, $b) {
        return strcmp(json_encode($a), json_encode($b));
    });

    $diffArray2 = array_udiff($array2, $array1, function($a, $b) {
        return strcmp(json_encode($a), json_encode($b));
    });

    $diffArray = array_merge($diffArray1, $diffArray2);

    return $diffArray;
}
