<?php  defined('BASEPATH') OR exit('No direct script access allowed');

use GuzzleHttp\Client;

class Product_upload_etsy extends CI_Controller { 

	public function __construct()
	{
		parent::__construct();
		header('X-Robots-Tag: noindex');

	}
	
	function run_job() {
		$this->processAddJewelry();

		$this->processUpdateJewelry();

		$this->addNewVariant();
		
		$this->updateQuantity();
		
		$this->processAddProductMetafield();
		
		$this->processUpdateProductMetafield();
		
		$this->processAddVariantMetafield();
		
		$this->processUpdateVariantMetafield();

		$this->processUploadImage();

		/* Every process will execute only if the previous process has no records. */
	}

	private function processAddJewelry() {
		$updateLocal = [];

		$record = $this->db->query(
			"SELECT * FROM sh_product_raw WHERE is_upload = 0 LIMIT 30"
		)->result();	

		foreach($record as $row) {
			$checkQuery = $this->db->query(
				"SELECT product_id FROM sh_product_variant WHERE sku = BINARY '$row->sku' "
			)->result();

			if(!empty($checkQuery)) {
				$updateLocal[] = [
					'id'=> $row->id,
					'is_upload'=> 1,
				];
				continue;
			}

			$variants = json_decode($row->json_variant ?: '');

			foreach($variants as $vRow) {
				unset($vRow->metal_v, $vRow->size, $vRow->quality);
			}

			$dataSend = [
			    'product' => [
		            'title' => $row->title,
		            'body_html' => $row->body_html,
		            'product_type' => $row->product_type,
		            'status' => $row->status,
		            'vendor' => $row->vendor,
		            'tags' => $row->tags,
		            'variants' => $variants,
		            'options' => json_decode($row->json_option ?: '')
			    ]
			];

			if(!empty($row->handle)) {
	            $dataSend['product']['handle'][] = $row->handle;
            }

			$newRecord = $this->addProduct(json_encode($dataSend));
			
			$this->saveProduct($newRecord, 'insert');

			$this->saveHistory($dataSend, [
				'sku' => $row->sku,
				'product_status' => $row->status,
				'type' => 'insert'
			]);

			$updateLocal[] = [
				'id'=> $row->id,
				'is_upload'=> 1,
			];

			if (empty($newRecord)) {
				continue;
			}

			$this->saveQuantityToUpload(
				$variants,
				$newRecord->product->variants
			);

			$this->updateSeo('title_tag',
				$row->seo_title,
				$newRecord->product->id
			);

			$this->updateSeo('description_tag',
				$row->seo_description,
				$newRecord->product->id
			);

			$this->saveImageToUpload(
				$row->json_image, 
				$newRecord->product->id
			);

			$this->saveProductMetafieldToUpload(
				$row, 
				$newRecord
			);

			if(!empty($videos)) {
				$this->db->update(
					'sh_product', 
					['json_video'=> $row->json_video],
					['product_id'=> $newRecord->product->id]
				);
			}
		}

		if (!empty($updateLocal)) {
			$this->db->update_batch('sh_product_raw', $updateLocal, 'id');
		}

		if(!empty($record)) {
			exit;
		}
	}

	private function processUpdateJewelry() {
		$updateLocal = [];
		$sku = '';
		$product = $this->db->query(
			"SELECT * FROM sh_product WHERE is_update = 1 AND is_upload = 0 LIMIT 50"
		)->result();
		
    	foreach($product as $row) {
    		$variants = [];

    		$productVariant = $this->db->query(
				"SELECT * FROM sh_product_variant WHERE is_new = 0 AND product_id = $row->product_id"
			)->result();

    		foreach($productVariant as $rv) {
		    	$variants[] = [
		    		'id' => $rv->variant_id,
	                'sku' => $rv->custom_metal_v,
	                'barcode' => $rv->barcode,
	                'price' => $rv->price,
	                'compare_at_price' => $rv->compare_at_price,
	                'cost' => $rv->cost,
	                'option1' => $rv->option1,
	                'option2' => $rv->option2
	            ];

	            $sku = $rv->custom_metal_v;
    		}

			$dataSend = [
			    'product' => [
			    	'id' => $row->product_id,
		            'title' => $row->title,
		            'handle' => $row->handle,
		            'body_html' => $row->body_html,
		            'product_type' => $row->product_type,
		            'status' => $row->status,
		            'tags' => $row->tags,
		            'variants' => $variants,
		            'options' => json_decode($row->json_option ?: '')
			    ]
			];

			$newRecord = $this->updateProduct(
				json_encode($dataSend), 
				$row->product_id
			);

			if (empty($newRecord)) {
				$updateLocal[] = [
					'id'=> $row->id,
					'is_update'=> 2,
					'is_upload'=> 2,
				];

				continue;
			}

			$this->saveQuantityToUpload(
				$productVariant,
				$newRecord->product->variants
			);
			
			$this->saveProduct($newRecord,'update');

			$this->saveHistory($dataSend, [
				'sku' => $sku,
				'product_status' => $row->status,
				'type' => 'update'
			]);

			$this->updateSeo('title_tag',
				$row->seo_title,
				$row->product_id
			);

			$this->updateSeo('description_tag',
				$row->seo_description,
				$row->product_id
			);
			
    	}

    	if (!empty($updateLocal)) {
			$this->db->update_batch('sh_product', $updateLocal, 'id');
		}

    	if(!empty($product)) {
			exit;
		}
	}

	private function addNewVariant() {
		$productVariant = $this->db->query(
			"SELECT * FROM sh_product_variant WHERE is_new = 1 LIMIT 30"
		)->result();
		
    	foreach($productVariant as $rv) {
            $product_id = $rv->product_id;

			$dataSend = [
			    'variant' => [
	                'sku' => $rv->custom_metal_v,
	                'barcode' => $rv->barcode,
	                'price' => $rv->price,
	                'compare_at_price' => $rv->compare_at_price,
	                'cost' => $rv->cost,
	                'option1' => $rv->option1,
	                'option2' => $rv->option2
	            ]
			];

			$newRecord = $this->addVariant(
				json_encode($dataSend), 
				$product_id
			);		

			if(empty($newRecord)) {
				$this->db->update('sh_product_variant', ['is_new' => 2 ], ['id' => $rv->id]);		

				continue;
			}

			$variant_id = $newRecord->variant->id;
			$inventory_item_id = $newRecord->variant->inventory_item_id;
			$title = $newRecord->variant->title;
			$newMetalV = $rv->custom_metal_v;
			$newSize = $rv->custom_size;
			$newQuality = $rv->custom_quality;

			// -------------------------------------------------------------
			// custom metafield metal_v

			if(!empty($newMetalV)) {
				$metafieldInsertData = [
					'variant_id'=> $variant_id,
					'namespace'=> 'custom',
					'meta_key'=> 'metal_v',
					'value'=> $newMetalV,
					'type'=> 'single_line_text_field',					
					'to_create'=> 1,
				];
				$this->db->insert('sh_variant_metafield', $metafieldInsertData);
			}

			// -------------------------------------------------------------
			// custom metafield sizing 

			if(!empty($newSize)) {
				$metafieldInsertData = [
					'variant_id'=> $variant_id,
					'namespace'=> 'custom',
					'meta_key'=> 'sizing',
					'value'=> $newSize,
					'type'=> 'single_line_text_field',					
					'to_create'=> 1,
				];
				$this->db->insert('sh_variant_metafield', $metafieldInsertData);
			}

			// -------------------------------------------------------------
			// custom metafield quality 

			if(!empty($newQuality)) {
				$metafieldInsertData = [
					'variant_id'=> $variant_id,
					'namespace'=> 'custom',
					'meta_key'=> 'quality',
					'value'=> $newQuality,
					'type'=> 'single_line_text_field',					
					'to_create'=> 1,
				];
				$this->db->insert('sh_variant_metafield', $metafieldInsertData);
			}

			// -------------------------------------------------------------

			$this->saveHistory($dataSend, [
				'sku' => $rv->custom_metal_v,
				'product_status' => '',
				'type' => 'add_variant'
			]);

			// -------------------------------------------------------------

			$variant_data = [
				'variant_id'=> $variant_id,
				'inventory_item_id'=> $inventory_item_id,
				'title'=> $title,
				'is_new' => 0		
			];

			$this->db->update('sh_product_variant', $variant_data, ['id' => $rv->id]);		
			
    	}

    	if(!empty($productVariant)) {
			exit;
		}
	}

	private function updateQuantity() {
		$updateLocal = [];

		$product = $this->db->query(
			"SELECT variant_id, inventory_item_id, inventory_quantity FROM sh_product_variant
			WHERE is_new = 0 AND is_quantity_update = 0 LIMIT 50"
		)->result();

    	foreach($product as $row) {
    		$variant_id = $row->variant_id;

			$dataInventory = [
			    "location_id"=> SHOP_LOCATION,
			    "inventory_item_id"=> $row->inventory_item_id,
			    "available"=> $row->inventory_quantity ?: 0
			];
			$updatedRecord = $this->updateInventory(json_encode($dataInventory));

			if(empty($updatedRecord)) {
				$updateLocal[] = [
					'variant_id'=> $variant_id,
					'is_quantity_update'=> 2,
				];

				continue;
			}

    		$updateLocal[] = [
				'variant_id'=> $variant_id,
				'is_quantity_update'=> 1,
			];
			
    	}

		if (!empty($updateLocal)) {
			$this->db->update_batch('sh_product_variant', $updateLocal, 'variant_id');
		}

		if(!empty($product)) {
			exit;
		}	
	}

	private function processAddProductMetafield() {
		$updateLocal = [];

		$productMetafield = $this->db->query(
			"SELECT * FROM sh_product_metafield WHERE to_create = 1 LIMIT 30"
		)->result();

		foreach($productMetafield as $row) {
			$product_id = $row->product_id;

			$dataInsert = [
			    "metafield" => [
			    	"namespace"=> $row->namespace,
				    "key"=> $row->meta_key,
				    "type"=> $row->type,
				    "value"=> $row->value
				]
			];

			$updatedRecord = $this->addMetafield(json_encode($dataInsert), 'products', $product_id);

			if(empty($updatedRecord)) {
				$updateLocal[] = [
					'id'=> $row->id,
					'to_create'=> 2,
				];

				continue;
			}

			$updateLocal[] = [
				'id'=> $row->id,
				'meta_id'=> $updatedRecord->metafield->id,
				'updated_at'=> date('Y-m-d H:i:s', strtotime($updatedRecord->metafield->updated_at)),
				'to_create'=> 0,
			];	

		}

		if (!empty($updateLocal)) {
			$this->db->update_batch('sh_product_metafield', $updateLocal, 'id');
		}

		if(!empty($productMetafield)) {
			exit;
		}
	}

	private function processUpdateProductMetafield() {
		$updateLocal = [];

		$productMetafield = $this->db->query(
			"SELECT * FROM sh_product_metafield WHERE to_update = 1 LIMIT 30"
		)->result();

		foreach($productMetafield as $row) {
			$product_id = $row->product_id;
			$meta_id = $row->meta_id;

			$dataInsert = [
			    "metafield" => [
				    "id"=> $meta_id,
				    "value"=> $row->value
				]
			];

			$updatedRecord = $this->updateMetafield(json_encode($dataInsert), 'products', $product_id, $meta_id);

			if(empty($updatedRecord)) {
				$updateLocal[] = [
					'id'=> $row->id,
					'to_update'=> 2,
				];

				continue;
			}

			$updateLocal[] = [
				'id'=> $row->id,
				'updated_at'=> date('Y-m-d H:i:s', strtotime($updatedRecord->metafield->updated_at)),
				'to_update'=> 0,
			];	

		}

		if (!empty($updateLocal)) {
			$this->db->update_batch('sh_product_metafield', $updateLocal, 'id');
		}

		if(!empty($productMetafield)) {
			exit;
		}
	}

	private function processAddVariantMetafield() {
		$updateLocal = [];

		$variantMetafield = $this->db->query(
			"SELECT * FROM sh_variant_metafield WHERE to_create = 1 LIMIT 30"
		)->result();

		foreach($variantMetafield as $row) {
			$variant_id = $row->variant_id;

			$dataInsert = [
			    "metafield" => [
			    	"namespace"=> $row->namespace,
				    "key"=> $row->meta_key,
				    "type"=> $row->type,
				    "value"=> $row->value
				]
			];

			$updatedRecord = $this->addMetafield(json_encode($dataInsert), 'variants', $variant_id);

			if(empty($updatedRecord)) {
				$updateLocal[] = [
					'id'=> $row->id,
					'to_create'=> 2,
				];

				continue;
			}

			$updateLocal[] = [
				'id'=> $row->id,
				'meta_id'=> $updatedRecord->metafield->id,
				'updated_at'=> date('Y-m-d H:i:s', strtotime($updatedRecord->metafield->updated_at)),
				'to_create'=> 0,
			];	

		}

		if (!empty($updateLocal)) {
			$this->db->update_batch('sh_variant_metafield', $updateLocal, 'id');
		}

		if(!empty($variantMetafield)) {
			exit;
		}
	}

	private function processUpdateVariantMetafield() {
		$updateLocal = [];

		$variantMetafield = $this->db->query(
			"SELECT * FROM sh_variant_metafield WHERE to_update = 1 LIMIT 30"
		)->result();

		foreach($variantMetafield as $row) {
			$variant_id = $row->variant_id;
			$meta_id = $row->meta_id;

			$dataInsert = [
			    "metafield" => [
				    "id"=> $meta_id,
				    "value"=> $row->value
				]
			];

			$updatedRecord = $this->updateMetafield(json_encode($dataInsert), 'variants', $variant_id, $meta_id);

			if(empty($updatedRecord)) {
				$updateLocal[] = [
					'id'=> $row->id,
					'to_update'=> 2,
				];
				
				continue;
			}

			$updateLocal[] = [
				'id'=> $row->id,
				// 'meta_id'=> $updatedRecord->metafield->id,
				'updated_at'=> date('Y-m-d H:i:s', strtotime($updatedRecord->metafield->updated_at)),
				'to_update'=> 0,
			];	

		}

		if (!empty($updateLocal)) {
			$this->db->update_batch('sh_variant_metafield', $updateLocal, 'id');
		}

		if(!empty($variantMetafield)) {
			exit;
		}
	}

	function processUploadImage() {
		$updateLocal = [];

		$product = $this->db->query(
			"SELECT product_id, json_image FROM sh_product
			WHERE is_image_upload = 0 LIMIT 5"
		)->result();	

    	foreach($product as $row) {
    		$product_id = $row->product_id;

    		$updateLocal[] = [
				'product_id'=> $product_id,
				'is_image_upload'=> 1,
			];

			$imageList = json_decode($row->json_image ?? '');

			if(empty($imageList)) {
				continue;
			}

    		$images = [];
    		$imgNameMergedArr = [];

    		foreach($imageList as $key => $imgRow) {
				$imgName = $imgRow->name;    	

				$imgArray = [
					'src' => $imgRow->src,
					'position' => ($imgRow->image_position ?? $key + 1)
			    ];

			    //----------------------------------------------------------------- 
			    if(!in_array($imgName, $imgNameMergedArr)) {
					$variant_ids = $this->findImageVariant($imgName, $product_id);

				    if(!empty($variant_ids)) {
				        $imgArray['variant_ids'] = $variant_ids;
				    }
			    }
			    
			    $imgNameMergedArr[] = $imgName; 
			    //----------------------------------------------------------------- 

				$images[] = $imgArray;
			}

			$dataSend = [
			    'product' => [
			    	'id' => $product_id,
		            'images' => $images
			    ]
			];

			$updatedRecord = $this->updateProductImage(
				json_encode($dataSend), 
				$product_id
			);

			if(empty($updatedRecord)) {
				continue;
			}

			// -------------------------------------------------------------
			$image_data = [];

			foreach($updatedRecord->product->images as $iRow) {
				$image_data[] = [
					'image_id'=> $iRow->id,
					'product_id'=> $product_id,
					'src'=> $iRow->src,
					'position'=> $iRow->position,
					'updated_at'=> date('Y-m-d H:i:s', strtotime($iRow->updated_at)),						
				];
			}

			if(!empty($image_data)) {
				$this->db->delete('sh_product_image', ['product_id'=> $product_id]);	
				$this->db->insert_batch('sh_product_image', $image_data);		
			}
			// -------------------------------------------------------------			

			$this->saveHistory($dataSend, [
				'sku' => $row->product_id,
				'product_status' => '',
				'type' => 'image'
			]);
			
    	}

		if (!empty($updateLocal)) {
			$this->db->update_batch('sh_product', $updateLocal, 'product_id');
		}	
	}

	private function findImageVariant($imgName, $product_id) {
		$imgName = strtolower($imgName);
		$color = '';

		if(str_starts_with($imgName, 'white')) {
			$color = 'w';
		} else if(str_starts_with($imgName, 'yellow')) {
			$color = 'y';
		} else if(str_starts_with($imgName, 'rose')) {
			$color = 'r';
		}

		if(empty($color)) {
			return [];
		}

		$variantList = $this->db->query(
			"SELECT variant_id FROM sh_product_variant 
			WHERE product_id = $product_id AND option1 LIKE '%$color'"
		)->result();

		$variant_id = [];

		foreach($variantList as $vRow) {
			$variant_id[] = $vRow->variant_id;
		}

		return $variant_id;
	}

	private function updateSeo($key, $value, $product_id) {
		if (empty($value)) {
			return;
		}

		$data = [
			'metafield' => [
				'namespace' => 'global',
		        'type' => 'string',
		        'key' => $key,
		        'value' => $value
			]
		];

		$this->addMetafield(json_encode($data), 'products', $product_id);
	}

	/*save product details to local DB*/
	private function saveProduct($newProduct, $type) {		
		if(empty($newProduct) || empty($newProduct->product)) {
			return '';
		}

		$product_data = [];
		$variant_data = [];
		$image_data = [];

		$product_data = [
			'product_id'=> $newProduct->product->id,
			'title'=> $newProduct->product->title,
			'handle'=> $newProduct->product->handle,
			'body_html'=> $newProduct->product->body_html,
			'product_type'=> $newProduct->product->product_type,
			'status'=> $newProduct->product->status,
			'vendor'=> $newProduct->product->vendor,
			'tags'=> $newProduct->product->tags,
			// 'published'=> '',
			// 'seo_description'=> '',
			// 'seo_title'=> '',
			// 'json_data'=> json_encode($newProduct->product),
			'edited_at'=> date('Y-m-d h:i'),
			'is_insert'=> 0,
			'is_update'=> 0,
			'is_upload'=> 1,
		];		

		foreach($newProduct->product->variants as $vRow) {
		  // echo "<pre>"; print_r( $vRow ); die;
			$variant_data[] = [
				'variant_id'=> $vRow->id,
				'product_id'=> $newProduct->product->id,
				'title'=> $vRow->title,
				'option1'=> $vRow->option1,
				'option2'=> $vRow->option2,
				'sku'=> $vRow->sku ,
				'barcode'=> $vRow->barcode,
				'price'=> $vRow->price,
				'compare_at_price'=> $vRow->compare_at_price,
				'inventory_item_id'=> $vRow->inventory_item_id,
				'inventory_policy'=> $vRow->inventory_policy,
				'inventory_management'=> $vRow->inventory_management,
				'fulfillment_service'=> $vRow->fulfillment_service,
				'taxable'=> $vRow->taxable,
				'position'=> $vRow->position,					
			];
		}
		

		if($type == 'insert') {
			$product_data['added_at'] = date('Y-m-d h:i');
			
			if(!empty($product_data)) {
				$this->db->insert('sh_product', $product_data);			
			}
			if(!empty($variant_data)) {
				$this->db->insert_batch('sh_product_variant', $variant_data);			
			}

		} else if($type == 'update') {
			if(!empty($product_data)) {
				$this->db->update('sh_product', $product_data, ['product_id'=> $newProduct->product->id]);			
			}
			if(!empty($variant_data)) {
				$this->db->update_batch('sh_product_variant', $variant_data, 'variant_id');			
			}
		}
	}

	// save to quantity upload queue
	private function saveQuantityToUpload($variants, $newRecordVariants) {		
		if(empty($variants) || empty($newRecordVariants)) {
			return;
		}

		foreach($variants as $rv) {
			$variantQuantity[$rv->barcode] = ['inventory_quantity' => $rv->inventory_quantity];
		}

		foreach($newRecordVariants as $rv) {
			$this->db->update('sh_product_variant', 
				[
					'inventory_quantity'=> $variantQuantity[$rv->barcode]['inventory_quantity'] ?: 0,
					'is_quantity_update'=> 0
				], 
				['inventory_item_id'=> $rv->inventory_item_id]
			);
		}	
	}

	// save to product metafield upload queue
	private function saveProductMetafieldToUpload($record, $newProduct) {		
		if(empty($record) || empty($newProduct)) {
			return;
		}

		$product_id = $newProduct->product->id;
		$jewelryDetailsdArr = json_decode($record->json_jewelry_details, true);
		$gemstoneDetailsArr = json_decode($record->json_gemstone_details, true);
		$setcode = $record->setcode;

		// -------------------------------------------------------------
		// custom metafield jewelry_details

		if(!empty($jewelryDetailsdArr)) {
			$metafieldInsertData = [
				'product_id'=> $product_id,
				'namespace'=> 'custom',
				'meta_key'=> 'jewelry_details',
				'value'=> json_encode($jewelryDetailsdArr),
				'type'=> 'list.single_line_text_field',					
				'to_create'=> 1,
			];

			$this->db->insert('sh_product_metafield', $metafieldInsertData);
		}

		// -------------------------------------------------------------
		// custom metafield gemstone_details

		if(!empty($gemstoneDetailsArr)) {
			$metafieldInsertData = [
				'product_id'=> $product_id,
				'namespace'=> 'custom',
				'meta_key'=> 'gemstone_details',
				'value'=> json_encode($gemstoneDetailsArr),
				'type'=> 'list.single_line_text_field',					
				'to_create'=> 1,
			];
			
			$this->db->insert('sh_product_metafield', $metafieldInsertData);
		}

		// -------------------------------------------------------------
		// custom metafield setcode

		if(!empty($setcode)) {
			$metafieldInsertData = [
				'product_id'=> $product_id,
				'namespace'=> 'custom',
				'meta_key'=> 'setcode',
				'value'=> $setcode,
				'type'=> 'single_line_text_field',					
				'to_create'=> 1,
			];

			$this->db->insert('sh_product_metafield', $metafieldInsertData);
		}

		// -------------------------------------------------------------
		// variants metafields

		$variants = json_decode($record->json_variant ?: '');

		$this->saveVariantMetafieldToUpload(
			$variants, 
			$newProduct->product->variants
		);
	}

	// save to variants metafield upload queue
	private function saveVariantMetafieldToUpload($variants, $newRecordVariants) {		
		if(empty($variants) || empty($newRecordVariants)) {
			return;
		}

		foreach($variants as $rv) {
			$variantCustomArr[$rv->barcode] = [
				'metal_v' => $rv->metal_v,
				'size' => $rv->size,
				'quality' => $rv->quality,
			];
		}

		foreach($newRecordVariants as $rv) {
			$variant_id = $rv->id;
			$newMetalV = $variantCustomArr[$rv->barcode]['metal_v'] ?: 0;
			$newSize = $variantCustomArr[$rv->barcode]['size'] ?: 0;
			$newQuality = $variantCustomArr[$rv->barcode]['quality'] ?: 0;

			// -------------------------------------------------------------
			// custom metafield metal_v

			if(!empty($newMetalV)) {
				$metafieldInsertData = [
					'variant_id'=> $variant_id,
					'namespace'=> 'custom',
					'meta_key'=> 'metal_v',
					'value'=> $newMetalV,
					'type'=> 'single_line_text_field',					
					'to_create'=> 1,
				];
				$this->db->insert('sh_variant_metafield', $metafieldInsertData);
			}

			// -------------------------------------------------------------
			// custom metafield sizing 

			if(!empty($newSize)) {
				$metafieldInsertData = [
					'variant_id'=> $variant_id,
					'namespace'=> 'custom',
					'meta_key'=> 'sizing',
					'value'=> $newSize,
					'type'=> 'single_line_text_field',					
					'to_create'=> 1,
				];
				$this->db->insert('sh_variant_metafield', $metafieldInsertData);
			}
			// -------------------------------------------------------------
			// custom metafield quality 

			if(!empty($newQuality)) {
				$metafieldInsertData = [
					'variant_id'=> $variant_id,
					'namespace'=> 'custom',
					'meta_key'=> 'quality',
					'value'=> $newQuality,
					'type'=> 'single_line_text_field',					
					'to_create'=> 1,
				];
				$this->db->insert('sh_variant_metafield', $metafieldInsertData);
			}
		}	
	}

	// save to image upload queue
	private function saveImageToUpload($images, $product_id) {		
		if(empty($images)) {
			return;
		}

		$this->db->update(
			'sh_product', 
			['json_image'=> $images, 'is_image_upload'=> 0],
			['product_id'=> $product_id]
		);	
	}

	private function addProduct($jsonBody) {
		if(empty($jsonBody)) {
			return [];
		}

		$this->delay(1);

		$client = new Client([
		    'base_uri' => SHOP_URL
		]);

		$headers = [
			'Content-Type' => 'application/json',
		  	'X-Shopify-Access-Token' => SHOP_TOKEN
		];
		  
		$response = $client->request('POST', 'products.json', [
			'http_errors' => false,
			'headers' => $headers,
		    'body' => $jsonBody
		]);
		  
		$body = $response->getBody();
		$parsedBody = json_decode($body);

		if($response->getStatusCode() > 300) {
			$dataError = [
				'request' => $jsonBody,
				'response' => json_encode($parsedBody),
				'method' => 'POST',
				'endpoint' => 'products.json',
				'added_at' => date('Y-m-d h:i'),
			];
			$this->db->insert('error_log', $dataError);

		    return [];
		}

		return $parsedBody;
	}

	private function updateProduct($jsonBody, $product_id) {
		if(empty($jsonBody)) {
			return [];
		}
		$this->delay(1);

		$client = new Client([
		    'base_uri' => SHOP_URL
		]);

		$headers = [
			'Content-Type' => 'application/json',
		  	'X-Shopify-Access-Token' => SHOP_TOKEN
		];
		  
		$response = $client->request('PUT', "products/$product_id.json", [
			'http_errors' => false,
			'headers' => $headers,
		    'body' => $jsonBody
		]);
	
		$body = $response->getBody();
		$parsedBody = json_decode($body);

		if($response->getStatusCode() > 300) {
			$dataError = [
				'request' => $jsonBody,
				'response' => json_encode($parsedBody),
				'method' => 'PUT',
				'endpoint' => "products/$product_id.json",
				'added_at' => date('Y-m-d h:i'),
			];
			$this->db->insert('error_log', $dataError);

		    return [];
		}

		return $parsedBody;
	}

	private function addVariant($jsonBody, $product_id) {
		if(empty($jsonBody)) {
			return [];
		}
		$this->delay(1);

		$client = new Client([
		    'base_uri' => SHOP_URL
		]);

		$headers = [
			'Content-Type' => 'application/json',
		  	'X-Shopify-Access-Token' => SHOP_TOKEN
		];
		  
		$response = $client->request('POST', "products/$product_id/variants.json", [
			'http_errors' => false,
			'headers' => $headers,
		    'body' => $jsonBody
		]);
	
		$body = $response->getBody();
		$parsedBody = json_decode($body);

		if($response->getStatusCode() > 300) {
			$dataError = [
				'request' => $jsonBody,
				'response' => json_encode($parsedBody),
				'method' => 'POST',
				'endpoint' => "products/$product_id/variants.json",
				'added_at' => date('Y-m-d h:i'),
			];
			$this->db->insert('error_log', $dataError);

		    return [];
		}

		return $parsedBody;
	}

	private function addMetafield($jsonBody, $type, $item_id) {
		if(empty($jsonBody)) {
			return [];
		}

		$this->delay(1);

		$client = new Client([
		    'base_uri' => SHOP_URL
		]);

		$headers = [
			'Content-Type' => 'application/json',
		  	'X-Shopify-Access-Token' => SHOP_TOKEN
		];
		  
		$endpoint = "$type/$item_id/metafields.json";

		$response = $client->request('POST', $endpoint, [
			'http_errors' => false,
			'headers' => $headers,
		    'body' => $jsonBody
		]);
	
		$body = $response->getBody();
		$parsedBody = json_decode($body);

		if($response->getStatusCode() > 300) {
			$dataError = [
				'request' => $jsonBody,
				'response' => json_encode($parsedBody),
				'method' => 'POST',
				'endpoint' => $endpoint,
				'added_at' => date('Y-m-d h:i'),
			];
			$this->db->insert('error_log', $dataError);

		    return [];
		}

		return $parsedBody;
	}

	private function updateMetafield($jsonBody, $type, $item_id, $metafield_id) {
		if(empty($jsonBody)) {
			return [];
		}

		$this->delay(1);

		$client = new Client([
		    'base_uri' => SHOP_URL
		]);

		$headers = [
			'Content-Type' => 'application/json',
		  	'X-Shopify-Access-Token' => SHOP_TOKEN
		];

		$endpoint = "$type/$item_id/metafields/$metafield_id.json";
		  
		$response = $client->request('PUT', $endpoint, [
			'http_errors' => false,
			'headers' => $headers,
		    'body' => $jsonBody
		]);
	
		$body = $response->getBody();
		$parsedBody = json_decode($body);

		if($response->getStatusCode() > 300) {
			$dataError = [
				'request' => $jsonBody,
				'response' => json_encode($parsedBody),
				'method' => 'PUT',
				'endpoint' => $endpoint,
				'added_at' => date('Y-m-d h:i'),
			];
			$this->db->insert('error_log', $dataError);

		    return [];
		}

		return $parsedBody;
	}

	private function updateInventory($jsonBody) {
		if(empty($jsonBody)) {
			return [];
		}
		
		$this->delay(1);

		$client = new Client([
		    'base_uri' => SHOP_URL
		]);

		$headers = [
			'Content-Type' => 'application/json',
		  	'X-Shopify-Access-Token' => SHOP_TOKEN
		];
		  
		$response = $client->request('POST', "inventory_levels/set.json", [
			'http_errors' => false,
			'headers' => $headers,
		    'body' => $jsonBody
		]);
	
		$body = $response->getBody();
		$parsedBody = json_decode($body);

		if($response->getStatusCode() > 300) {
			$dataError = [
				'request' => $jsonBody,
				'response' => json_encode($parsedBody),
				'method' => 'POST',
				'endpoint' => "inventory_levels/set.json",
				'added_at' => date('Y-m-d h:i'),
			];
			$this->db->insert('error_log', $dataError);

		    return [];
		}

		return $parsedBody;
	}

	private function updateProductImage($jsonBody, $product_id) {
		if(empty($jsonBody)) {
			return [];
		}

		$client = new Client([
		    'base_uri' => SHOP_URL
		]);

		$headers = [
			'Content-Type' => 'application/json',
		  	'X-Shopify-Access-Token' => SHOP_TOKEN
		];
		  
		$response = $client->request('PUT', "products/$product_id.json", [
			'http_errors' => false,
			"headers" => $headers,
		    "body" => $jsonBody
		]);
		  
		$body = $response->getBody();
		$parsedBody = json_decode($body);

		if($response->getStatusCode() > 300) {
			$dataError = [
				'request' => $jsonBody,
				'response' => json_encode($parsedBody),
				'method' => 'PUT',
				'endpoint' => "products/$product_id.json",
				'added_at' => date('Y-m-d h:i'),
			];
			$this->db->insert('error_log', $dataError);

		    return [];
		}

		return $parsedBody;
	}	

	private function saveHistory($jsonBody, $args) {
		if(empty($jsonBody)) {
			return;
		}

		$data = [			
			'sku' => $args['sku'],			
			'product_status' => $args['product_status'],
			'type' => $args['type'],
			'added_at' => date('Y-m-d h:i')
		];

		$this->db->delete('last_upload_log', ['sku' => $args['sku']]);
		$this->db->insert('last_upload_log', $data);

		$data['json_data'] = json_encode($jsonBody);
		$this->db->insert('sh_upload_history', $data);
	}

	private function delay($sec) {
		sleep($sec);
	}


}
