<?php  defined('BASEPATH') OR exit('No direct script access allowed');

use GuzzleHttp\Client;

class Product_raw_simplex_etsy extends CI_Controller { 

	public function __construct()
	{
		parent::__construct();
		header('X-Robots-Tag: noindex');

	}

	function run_job() {		
		$jewelryRecord = $this->getJewelry([]);

		$this->processJewelryList($jewelryRecord);		
		$this->archiveUnavailableRecord($jewelryRecord);
	}

	private function processJewelryList($jewelryRecord) {
		/*$field['from'] = date("Y-m-d", strtotime("-1 day"));
		$field['to'] = date("Y-m-d", strtotime("+1 day"));
		$jewelryRecord = $this->getJewelry([]);*/

		if (empty($jewelryRecord)) {
			return;
		}

		foreach ($jewelryRecord as $row) {
			if(empty($row['variants'])) {
				continue;
			}
		
// 			foreach ($row['variants'] as $row1) {
// 			     $sku = trim($row1['metal_v']);	
// 				}
            $sku = trim($row['sku']);	
			
			$data_updated_at = $row['updated_at'];	

			/*$checkLog = $this->db->query(
				"SELECT id FROM last_upload_log 
				WHERE sku = BINARY '$sku' AND data_updated_at = '$data_updated_at' "
			)->result();

			if(!empty($checkLog)) {
				continue;
			}*/

			$record = $this->prepareJewelryData($row);

			// -----------------------------------------------------------------

// 			$checkVariant = $this->db->query(
// 				"SELECT product_id FROM sh_product_variant 
// 				WHERE sku = BINARY '$sku' ORDER BY id LIMIT 1"
// 			)->result();
           $checkVariant = $this->db->query(
                        "SELECT product_id FROM sh_product_variant 
                         WHERE sku LIKE '%$sku%'
                         LIMIT 1"
                    )->result();

			if(!empty($checkVariant)) {
				$this->updateJewelry($record, $checkVariant[0]->product_id);
				continue;
			}

			// -----------------------------------------------------------------

			$checkVariantDeleted = $this->db->query(
				"SELECT product_id FROM sh_product_variant_deleted 
				WHERE sku = BINARY '$sku' ORDER BY id LIMIT 1"
			)->result();

			if(!empty($checkVariantDeleted)) {
				$this->updateJewelry($record, $checkVariantDeleted[0]->product_id);
				continue;
			}

			// -----------------------------------------------------------------

			$checkProduct = $this->db->query(
				"SELECT id FROM sh_product_raw WHERE sku = BINARY '$sku' "
			)->result();

			if(empty($checkProduct)) {
				$this->db->insert('sh_product_raw', $record);
			}

		}		
	}

	/*update jewelry to local DB*/
	private function updateJewelry($row, $product_id) {
		if(empty($row)) {
			return '';
		}
		// -------------------------------------------------------------
		// image compare 

		$recordImage = $this->db->query(
			"SELECT json_image FROM sh_product WHERE product_id = $product_id"
		)->result();

		$oldImages = json_decode($recordImage[0]->json_image ?? '', true);
		$newImages = json_decode($row['json_image'], true);

		$diffImage = multiArrayDiff($oldImages, $newImages);

		// -------------------------------------------------------------
		// custom metafield gemstone_details compare 

		$recordMeta = $this->db->query(
			"SELECT meta_id, value FROM sh_product_metafield 
			WHERE product_id = $product_id AND meta_key = 'gemstone_details'"
		)->result();

		$customMetafieldArr = json_decode($row['json_gemstone_details'], true);

		if(!empty($recordMeta) && !empty($customMetafieldArr)) {
			$diffMeta = 0;

			if(!empty($recordMeta[0]->meta_id)) {
				$oldMeta = $recordMeta[0]->value ?: '[]';
				$newMeta = json_encode($customMetafieldArr);

				$diffMeta = strcmp($oldMeta, $newMeta);
			}

			if($diffMeta != 0) {
				$this->db->update(
					'sh_product_metafield', 
					['value'=> json_encode($customMetafieldArr), 'to_update'=> 1 ],
					['meta_id'=> $recordMeta[0]->meta_id]
				);
			}

		} else if(empty($recordMeta) && !empty($customMetafieldArr)) {
			$metafieldInsertData = [
				'product_id'=> $product_id,
				'namespace'=> 'custom',
				'meta_key'=> 'gemstone_details',
				'value'=> json_encode($customMetafieldArr),
				'type'=> 'list.single_line_text_field',					
				'to_create'=> 1,
			];
			$this->db->insert('sh_product_metafield', $metafieldInsertData);
		}

		// -------------------------------------------------------------
		// custom metafield jewelry_details compare 

		$recordMeta = $this->db->query(
			"SELECT meta_id, value FROM sh_product_metafield 
			WHERE product_id = $product_id AND meta_key = 'jewelry_details'"
		)->result();

		$customMetafieldArr = json_decode($row['json_jewelry_details'], true);

		if(!empty($recordMeta) && !empty($customMetafieldArr)) {
			$diffMeta = 0;

			if(!empty($recordMeta[0]->meta_id)) {
				$oldMeta = $recordMeta[0]->value ?: '[]';
				$newMeta = json_encode($customMetafieldArr);

				$diffMeta = strcmp($oldMeta, $newMeta);
			}

			if($diffMeta != 0) {
				$this->db->update(
					'sh_product_metafield', 
					['value'=> json_encode($customMetafieldArr), 'to_update'=> 1 ],
					['meta_id'=> $recordMeta[0]->meta_id]
				);
			}

		} else if(empty($recordMeta) && !empty($customMetafieldArr)) {
			$metafieldInsertData = [
				'product_id'=> $product_id,
				'namespace'=> 'custom',
				'meta_key'=> 'jewelry_details',
				'value'=> json_encode($customMetafieldArr),
				'type'=> 'list.single_line_text_field',					
				'to_create'=> 1,
			];
			$this->db->insert('sh_product_metafield', $metafieldInsertData);
		}

		// -------------------------------------------------------------
		// custom metafield setcode compare 

		$recordMeta = $this->db->query(
			"SELECT meta_id, value FROM sh_product_metafield 
			WHERE product_id = $product_id AND meta_key = 'setcode'"
		)->result();

		$newSetcode = $row['setcode'];

		if(!empty($recordMeta) && !empty($newSetcode)) {
			
			if($recordMeta[0]->value != $newSetcode) {
				$this->db->update(
					'sh_product_metafield', 
					['value'=> $newSetcode, 'to_update'=> 1 ],
					['meta_id'=> $recordMeta[0]->meta_id]
				);
			}

		} else if(empty($recordMeta) && !empty($newSetcode)) {
			$metafieldInsertData = [
				'product_id'=> $product_id,
				'namespace'=> 'custom',
				'meta_key'=> 'setcode',
				'value'=> $newSetcode,
				'type'=> 'single_line_text_field',					
				'to_create'=> 1,
			];
			$this->db->insert('sh_product_metafield', $metafieldInsertData);
		}

		// -------------------------------------------------------------

		$product_data = [
			'title'=> $row['title'],
			'handle'=> $row['handle'],
			'body_html'=> $row['body_html'],
			'product_type'=> $row['product_type'],
			'tags'=> $row['tags'],
			'status'=> $row['status'],
			'seo_title'=> $row['seo_title'],
			'seo_description'=> $row['seo_description'],
			'published'=> $row['published'],
		    'json_option' => $row['json_option'],
		    'json_video' => $row['json_video'],
		    // 'json_gemstone_details' => $row['json_gemstone_details'],
			'edited_at'=> date('Y-m-d h:i'),
			'is_update'=> 1,
			'is_upload'=> 0
		];

		if(!empty($diffImage)) {
			$product_data['json_image'] = $row['json_image'];
			$product_data['is_image_upload'] = 0;
		}

		$variants = json_decode(($row['json_variant'] ?: ''), true);
		$variant_data = [];
		$new_variant_data = [];

		foreach($variants as $rv) {
			$sku = trim($rv['metal_v'] ?? '');
			$barcode = $rv['barcode'] ?? '';
			$custom_size = $rv['size'] ?? '';
			$custom_metal_v = $rv['metal_v'] ?? '';
			$custom_quality = $rv['quality'] ?? '';

			$record = $this->db->query(
				"SELECT id, variant_id, product_id FROM sh_product_variant 
				WHERE sku = BINARY '$sku' AND barcode = BINARY '$barcode'"
			)->result();

			$auto_id = $record[0]->id ?? '';
			$variant_id = $record[0]->variant_id ?? '';
			$var_product_id = $record[0]->product_id ?? '';

			if(!empty($variant_id)) {
				$this->processVariantMetafield($rv, $variant_id);
			}

			unset($rv['size'], $rv['metal_v'], $rv['quality']);

			if(!empty($variant_id)) {
				$variant_data[] = [
					'variant_id'=> $variant_id,
					'custom_size'=> $custom_size,
					'custom_metal_v'=> $custom_metal_v,
					'custom_quality'=> $custom_quality,
					...$rv
				];

				continue;
			}

			if(empty($variant_id)) {
				$this->db->delete('sh_product_variant', ['id'=> $auto_id]);		

				$new_variant_data[] = [
					'product_id'=> $product_id,
					'custom_size'=> $custom_size,
					'custom_metal_v'=> $custom_metal_v,
					'custom_quality'=> $custom_quality,
					'is_new'=> 1,
					...$rv				
				];
			}

		}

		$this->db->update('sh_product', $product_data, ['product_id'=> $product_id]);

		if(!empty($variant_data)) {
			$this->db->update_batch('sh_product_variant', $variant_data, 'variant_id');

			// Delete Unavailable Variants
			$availableVariantIdArr = array_column($variant_data, 'variant_id');
			$availableVariantId = implode("','", $availableVariantIdArr);
			$this->db->query(
				"INSERT INTO sh_product_variant_deleted SELECT * FROM sh_product_variant  
				WHERE product_id = '$product_id' AND variant_id NOT IN('$availableVariantId')"
			);

			$this->db->query(
				"DELETE FROM sh_product_variant 
				WHERE product_id = '$product_id' AND variant_id NOT IN('$availableVariantId')"
			);
		}

		if(!empty($new_variant_data)) {
			$this->db->insert_batch('sh_product_variant', $new_variant_data);
		}

	}	

	private function processVariantMetafield($record, $variant_id)	{
		if(empty($variant_id)) {
			return;
		}	
		// -------------------------------------------------------------
		// custom metafield metal_v compare 

		$recordMeta = $this->db->query(
			"SELECT meta_id, value FROM sh_variant_metafield 
			WHERE variant_id = $variant_id AND meta_key = 'metal_v'"
		)->result();

		$newMetalV = $record['metal_v'];

		if(!empty($recordMeta) && !empty($newMetalV)) {

			if($recordMeta[0]->value != $newMetalV) {
				$this->db->update(
					'sh_variant_metafield', 
					['value'=> $newMetalV, 'to_update'=> 1 ],
					['meta_id'=> $recordMeta[0]->meta_id]
				);
			}

		} else if(empty($recordMeta) && !empty($newMetalV)) {
			$metafieldInsertData = [
				'variant_id'=> $variant_id,
				'namespace'=> 'custom',
				'meta_key'=> 'metal_v',
				'value'=> $newMetalV,
				'type'=> 'single_line_text_field',					
				'to_create'=> 1,
			];
			$this->db->insert('sh_variant_metafield', $metafieldInsertData);
		}

		// -------------------------------------------------------------
		// custom metafield sizing compare 

		$recordMeta = $this->db->query(
			"SELECT meta_id, value FROM sh_variant_metafield 
			WHERE variant_id = $variant_id AND meta_key = 'sizing'"
		)->result();

		$newSize = $record['size'];

		if(!empty($recordMeta) && !empty($newSize)) {

			if($recordMeta[0]->value != $newSize) {
				$this->db->update(
					'sh_variant_metafield', 
					['value'=> $newSize, 'to_update'=> 1 ],
					['meta_id'=> $recordMeta[0]->meta_id]
				);
			}

		} else if(empty($recordMeta) && !empty($newSize)) {
			$metafieldInsertData = [
				'variant_id'=> $variant_id,
				'namespace'=> 'custom',
				'meta_key'=> 'sizing',
				'value'=> $newSize,
				'type'=> 'single_line_text_field',					
				'to_create'=> 1,
			];
			$this->db->insert('sh_variant_metafield', $metafieldInsertData);
		}
		// -------------------------------------------------------------
		// custom metafield quality compare 

		$recordMeta = $this->db->query(
			"SELECT meta_id, value FROM sh_variant_metafield 
			WHERE variant_id = $variant_id AND meta_key = 'quality'"
		)->result();

		$newQuality = $record['quality'];

		if(!empty($recordMeta) && !empty($newQuality)) {

			if($recordMeta[0]->value != $newQuality) {
				$this->db->update(
					'sh_variant_metafield', 
					['value'=> $newQuality, 'to_update'=> 1 ],
					['meta_id'=> $recordMeta[0]->meta_id]
				);
			}

		} else if(empty($recordMeta) && !empty($newQuality)) {
			$metafieldInsertData = [
				'variant_id'=> $variant_id,
				'namespace'=> 'custom',
				'meta_key'=> 'quality',
				'value'=> $newQuality,
				'type'=> 'single_line_text_field',					
				'to_create'=> 1,
			];
			$this->db->insert('sh_variant_metafield', $metafieldInsertData);
		}
		
	}

	/*create array for jewelry data*/
	private function prepareJewelryData($row) {	
		$jewelry_details = [
			"Apx Ctw: {$row['appr_ctw']}",
			"Stone Type: {$row['stone_type']}",
			"Jewelry Type: {$row['product_type']}",
			"Jewelry Category: {$row['jewelry_category']}",
		];

		$gemstone_details = [
			"Stone Type: {$row['stone_type']}",
			"No Of Stones: {$row['diamond_quantity']}",
			"Average Color: {$row['avg_color']}",
			"Average Clarity: {$row['avg_clarity']}",
			"Carat Weight: {$row['appr_ctw']}",
			"Quality: {$row['colorstone_quality']}",
			"No Of Color Stones: {$row['colorstone_quantity']}",
		];
		
		$variants = [];
		$options = [];
		$metals = [];
		$ctws = [];
		$qualities = [];
		$images = [];
		$videos = [];
		$optionsMergedArr = [];

		foreach($row['variants'] as $rv) {
			$optionsMerged = $rv['metal'].$rv['ctw'];    	
        
	        if(in_array($optionsMerged, $optionsMergedArr)) {
	        	continue;
	        }
	        
	        $optionsMergedArr[] = $optionsMerged; 
	        //----------------------------------------------------------------- 

			$price = floatval($rv['price']);
			$compare_at_price = $price * 2;
			$cost = '';

			$variants[] = [
				'sku' => $rv['metal_v'],
			    'barcode' => $rv['item_no'],
			    'price' => $price,
			    'compare_at_price' => $compare_at_price,
			    'cost' => $cost,
			    'inventory_quantity' => $rv['inventory_quantity'],
			    'metal_v' => $rv['metal_v'],
			    'size' => $rv['size'],
			    'quality' => $rv['quality'],
			    'option1' => $rv['metal'],
			    'option2' => $rv['ctw'],
			    'taxable' => 1,
			    'fulfillment_service' => 'manual',
			    'inventory_policy' => 'deny',
			    'inventory_management' => 'shopify',
			];

			if(!empty($rv['metal'])) {
				$metals[] = $rv['metal'];
			}
			if(!empty($rv['ctw'])) {
				$ctws[] = $rv['ctw'];
			}

		}

		$variantsCount = count($variants);

		if(!empty($metals) && ($variantsCount == count($metals))) {
			$options[] = [
				'name' => 'Metal',
				'values' => $metals
			];
		}
		if(!empty($ctws) && ($variantsCount == count($ctws))) {
			$options[] = [
				'name' => 'Ctw',
				'values' => $ctws
			];
		}

		foreach($row['images'] as $ri) {
			$images[] = [
				'name' => $ri['metal'],
			    'src' => $ri['src'],
			];
		}
		foreach($row['videos'] as $ri) {
			$videos[] = [
				'name' => $ri['metal'],
			    'src' => $ri['src'],
			];
		}
// 			foreach ($row['variants'] as $row1) {
// 			     $sku = trim($row1['metal_v']);	
// 				}
// print_r($row); die;
		$data = [
			'sku' => $row['sku'],
			'setcode' => $row['setcode'],
		    'title' => $row['title'],
		    'body_html' => $row['description'],
		    'product_type' => $row['product_type'],
		    'jewelry_category' => $row['jewelry_category'],
		    'tags' => $row['jewelry_category'] . (!empty($row['tags']) ? ' ,'.$row['tags'] : ''),
		    'handle' => '',
		    'status' => $row['status'],
		    'published' => '',
		    'seo_description' => '',
		    'seo_title' => '',
		    'vendor' => 'SimplexDiam',
			    
		    // 'product_status' => $row['status'],
		    // 'wholesale_price' => $markup_price,
		    // 'grams' => $row['grams'],
		    // 'requires_shipping' => $row['requires_shipping'],
		    'json_variant' => json_encode($variants),
		    'json_option' => json_encode($options),
		    'json_image' => json_encode($images),
		    'json_video' => json_encode($videos),
		    'json_gemstone_details' => json_encode($gemstone_details),
		    'json_jewelry_details' => json_encode($jewelry_details),
		    'data_created_at' => $row['created_at'],
		    'data_updated_at' => $row['updated_at'],
		    'added_at' => date('Y-m-d h:i')
		];
// echo"<pre>";
// 			print_r($data ); die;
	return $data;
	}

	private function archiveUnavailableRecord($jewelryRecord) {
		if (empty($jewelryRecord)) {
			return;
		}
		$product_data = [];

		$productList = $this->db->query(
			"SELECT product_id,status,
				(SELECT sku FROM sh_product_variant v 
				WHERE v.product_id=p.product_id limit 1) AS sku 
			FROM sh_product p WHERE status = 'active'"
		)->result();

		$availabelSKU = array_column($jewelryRecord, 'sku');
		$availabelSKU = array_map('trim', $availabelSKU);

		foreach ($productList as $row) {
			if(in_array(trim($row->sku ?? ''), $availabelSKU)) {
				continue;
			}

			$product_data[] = [
				'product_id'=> $row->product_id,
				'status'=> 'archived',
				'edited_at'=> date('Y-m-d h:i'),
				'is_update'=> 1,
				'is_upload'=> 0
			];
		}

		if(!empty($product_data)) {
			$this->db->update_batch('sh_product', $product_data, 'product_id');
		}

	}

	/*get jewelry list*/
	private function getJewelry($params) {
		$record = [];

		$client = new Client();

		$headers = [];
		  
		$response = $client->request('GET', 'https://shop.simplexdiam.com/admin/Auto_etsy_api', [
			'http_errors' => false,
			'headers' => $headers,
		    'query' => $params
		]);
		  
		if($response->getStatusCode() > 300) {
		    return $record;
		}

		$body = $response->getBody();
		$parsedBody = json_decode($body, true);

		$record = $parsedBody['records'];

		$dataLog = [
            'request' => json_encode($params),
            'response' => json_encode($parsedBody),
            'method' => 'GET',
            'endpoint' => "https://shop.simplexdiam.com/admin/Auto_etsy_api",
            'added_at' => date('Y-m-d h:i'),
        ];
        $this->db->insert('external_api_log', $dataLog);

		return $record;
	}

	private function delay($sec) {
		sleep($sec);
	}


}
